<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="container mt-6">
    <a href="<?= Url::to(['/tour']) ?>" class="btn btn-secondary mb-4">← Назад</a>

    <div class="grid grid-cols-2 gap-6">
        <!-- Left column -->
        <div>
            <h1 class="mb-3"><?= Html::encode($tour->title) ?></h1>

            <?php if ($tour->image): ?>
                <div style="border-radius: 8px; overflow: hidden; margin-bottom: 2rem;">
                    <img src="../uploads/<?= Html::encode($tour->image) ?>"
                         alt="<?= Html::encode($tour->title) ?>"
                         style="width: 100%; height: 300px; object-fit: cover;">
                </div>
            <?php endif; ?>

            <div class="mb-4">
                <h3 class="mb-2">Описание</h3>
                <p><?= nl2br(Html::encode($tour->description)) ?></p>
            </div>

            <div>
                <h3 class="mb-2">Программа</h3>
                <div style="white-space: pre-line; background: var(--light-gray); padding: 1.5rem; border-radius: 6px;">
                    <?= Html::encode($tour->program) ?>
                </div>
            </div>
        </div>

        <!-- Right column -->
        <div>
            <div class="card" style="position: sticky; top: 100px;">
                <div style="padding: 1.5rem;">
                    <h3 class="mb-3">Бронирование</h3>

                    <div style="margin-bottom: 2rem;">
                        <p class="text-gray mb-2">Стоимость за человека</p>
                        <div style="font-size: 2rem; font-weight: 700; color: var(--accent);">
                            <?= number_format($tour->price, 0, '', ' ') ?> ₽
                        </div>
                    </div>

                    <?php if (!Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['booking/create', 'tour_id' => $tour->id]) ?>" class="btn" style="width: 100%;">Забронировать</a>
                    <?php else: ?>
                        <div class="text-center">
                            <p class="text-gray mb-3">Для бронирования войдите в систему</p>
                            <a href="<?= Url::to(['/auth/login']) ?>" class="btn">Войти</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Reviews -->
    <div class="mt-6">
        <h2 class="mb-4">Отзывы</h2>

        <?php if (empty($reviews)): ?>
            <div class="text-center text-gray">
                <p>Отзывов пока нет</p>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-2 gap-4">
                <?php foreach ($reviews as $review): ?>
                    <div class="card">
                        <div style="padding: 1.5rem;">
                            <div style="display: flex; justify-content: space-between; margin-bottom: 1rem;">
                                <strong><?= Html::encode($review->user->fio ?? 'Аноним') ?></strong>
                                <span style="color: #f59e0b;"><?= str_repeat('★', $review->rating) ?></span>
                            </div>
                            <p class="text-gray"><?= Html::encode($review->text) ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>