<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

    <div class="container">
        <!-- Hero Section -->
        <div class="text-center mb-3">
            <h1 class="mb-1">Туры выходного дня</h1>
            <p>Откройте для себя Урал</p>
        </div>

        <!-- Search -->
        <div class="card mb-3" style="padding: 20px;">
            <form method="get" action="<?= Url::to(['/tour/index']) ?>" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Поиск туров..." style="flex: 1;">
                <button type="submit" class="btn">Найти</button>
            </form>
        </div>

        <!-- Popular Tours -->
        <h2 class="mb-2">Популярные туры</h2>

        <?php if (empty($tours)): ?>
            <div class="card text-center" style="padding: 40px;">
                <p>Туры не найдены</p>
            </div>
        <?php else: ?>
            <div class="row">
                <?php foreach ($tours as $tour): ?>
                    <div class="col col-4">
                        <div class="card">
                            <?php if ($tour->image): ?>
                                <img src="uploads/<?= Html::encode($tour->image) ?>"
                                     alt="<?= Html::encode($tour->title) ?>"
                                     style="width: 100%; height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div style="height: 200px; background: #eee; display: flex; align-items: center; justify-content: center; color: #999;">
                                    Нет фото
                                </div>
                            <?php endif; ?>

                            <div style="padding: 15px;">
                                <h3 style="margin-bottom: 10px;"><?= Html::encode($tour->title) ?></h3>
                                <p style="color: #666; margin-bottom: 15px; font-size: 14px;">
                                    <?= Html::encode(mb_substr($tour->description, 0, 80)) ?>...
                                </p>
                                <div style="display: flex; justify-content: space-between; align-items: center;">
                                    <div style="font-weight: bold; color: #0066cc;">
                                        <?= number_format($tour->price, 0, '', ' ') ?> ₽
                                    </div>
                                    <a href="<?= Url::to(['tour/view', 'id' => $tour->id]) ?>" class="btn">Подробнее</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="text-center mt-2">
                <a href="<?= Url::to(['/tour/index']) ?>" class="btn btn-secondary">Все туры</a>
            </div>
        <?php endif; ?>

        <!-- Reviews -->
        <?php if (!empty($reviews)): ?>
            <h2 class="mt-3 mb-2">Отзывы</h2>
            <div class="row">
                <?php foreach ($reviews as $review): ?>
                    <div class="col col-6">
                        <div class="card" style="padding: 15px;">
                            <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                                <strong><?= Html::encode($review->user->fio ?? 'Аноним') ?></strong>
                                <span style="color: #ffb300;"><?= str_repeat('★', $review->rating) ?></span>
                            </div>
                            <p style="color: #666;"><?= Html::encode(mb_substr($review->text, 0, 150)) ?>...</p>
                            <p style="color: #999; font-size: 13px; margin-top: 10px;">
                                Тур: <?= Html::encode($review->tour->title) ?>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Leave Review Form for logged in users -->
<?php if (!Yii::$app->user->isGuest && !empty($userBookingTours)): ?>
    <div style="background: white; border-top: 1px solid #ddd; margin-top: 30px;">
        <div class="container" style="padding: 30px 15px;">
            <h2 class="text-center mb-2">Оставить отзыв</h2>

            <?php if (Yii::$app->session->hasFlash('reviewSuccess')): ?>
                <div style="background: #d4edda; color: #155724; padding: 10px; border-radius: 4px; margin-bottom: 15px;">
                    <?= Yii::$app->session->getFlash('reviewSuccess') ?>
                </div>
            <?php endif; ?>

            <form method="post" style="max-width: 600px; margin: 0 auto;">
                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                <input type="hidden" name="Review[user_id]" value="<?= Yii::$app->user->id ?>">

                <div class="row">
                    <div class="col col-6">
                        <div class="form-group">
                            <label>Тур</label>
                            <select name="Review[tour_id]" required>
                                <option value="">— Выберите тур —</option>
                                <?php foreach ($userBookingTours as $tour): ?>
                                    <option value="<?= $tour['id'] ?>"><?= Html::encode($tour['title']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col col-6">
                        <div class="form-group">
                            <label>Оценка</label>
                            <select name="Review[rating]" required>
                                <option value="">— Выберите оценку —</option>
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <option value="<?= $i ?>"><?= $i ?> звезд</option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label>Отзыв</label>
                    <textarea name="Review[text]" rows="3" required placeholder="Расскажите о впечатлениях..."></textarea>
                </div>

                <button type="submit" class="btn">Отправить отзыв</button>
            </form>
        </div>
    </div>
<?php endif; ?>