<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= Html::encode($this->title) ?></title>
        <?= Html::csrfMetaTags() ?>
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }

            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                line-height: 1.6;
                color: #333;
                background-color: #f5f5f5;
            }

            .container {
                max-width: 1200px;
                margin: 0 auto;
                padding: 0 15px;
            }

            /* Header */
            .header {
                background: white;
                border-bottom: 1px solid #ddd;
                padding: 15px 0;
            }

            .header-content {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .logo a {
                font-size: 20px;
                font-weight: 600;
                color: #333;
                text-decoration: none;
            }

            .nav {
                display: flex;
                gap: 20px;
            }

            .nav a {
                color: #555;
                text-decoration: none;
                padding: 5px 10px;
            }

            .nav a:hover {
                color: #0066cc;
            }

            /* Main content */
            main {
                min-height: calc(100vh - 140px);
                padding: 30px 0;
            }

            /* Footer */
            .footer {
                background: white;
                border-top: 1px solid #ddd;
                padding: 20px 0;
                text-align: center;
                color: #666;
            }

            /* Buttons */
            .btn {
                display: inline-block;
                padding: 10px 20px;
                background: #0066cc;
                color: white;
                text-decoration: none;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                font-size: 14px;
            }

            .btn:hover {
                background: #0052a3;
            }

            .btn-secondary {
                background: #6c757d;
            }

            .btn-secondary:hover {
                background: #545b62;
            }

            /* Cards */
            .card {
                background: white;
                border: 1px solid #ddd;
                border-radius: 4px;
                overflow: hidden;
            }

            /* Forms */
            .form-group {
                margin-bottom: 15px;
            }

            label {
                display: block;
                margin-bottom: 5px;
                font-weight: 500;
            }

            input, select, textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 4px;
                font-size: 14px;
            }

            input:focus, select:focus, textarea:focus {
                outline: none;
                border-color: #0066cc;
            }

            /* Grid */
            .row {
                display: flex;
                flex-wrap: wrap;
                margin: 0 -10px;
            }

            .col {
                padding: 0 10px;
                margin-bottom: 20px;
            }

            .col-1 { width: 8.33%; }
            .col-2 { width: 16.66%; }
            .col-3 { width: 25%; }
            .col-4 { width: 33.33%; }
            .col-5 { width: 41.66%; }
            .col-6 { width: 50%; }
            .col-7 { width: 58.33%; }
            .col-8 { width: 66.66%; }
            .col-9 { width: 75%; }
            .col-10 { width: 83.33%; }
            .col-11 { width: 91.66%; }
            .col-12 { width: 100%; }

            /* Utility */
            .text-center { text-align: center; }
            .mt-1 { margin-top: 10px; }
            .mt-2 { margin-top: 20px; }
            .mt-3 { margin-top: 30px; }
            .mb-1 { margin-bottom: 10px; }
            .mb-2 { margin-bottom: 20px; }
            .mb-3 { margin-bottom: 30px; }

            /* Responsive */
            @media (max-width: 768px) {
                .col-3, .col-4, .col-6 {
                    width: 100%;
                }

                .header-content {
                    flex-direction: column;
                    gap: 15px;
                }

                .nav {
                    flex-wrap: wrap;
                    justify-content: center;
                }
            }
        </style>
        <?php $this->head() ?>
    </head>
    <body>
    <?php $this->beginBody() ?>

    <header class="header">
        <div class="container">
            <div class="header-content">
                <div class="logo">
                    <a href="<?= Url::to(['/site/index']) ?>">Туры выходного дня</a>
                </div>
                <nav class="nav">
                    <a href="<?= Url::to(['/site/index']) ?>">Главная</a>
                    <a href="<?= Url::to(['/tour/index']) ?>">Туры</a>
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['/booking/index']) ?>">Мои заявки</a>
                        <?php if (Yii::$app->user->identity->role === 'admin'): ?>
                            <a href="<?= Url::to(['/admin/index']) ?>">Админ</a>
                        <?php endif; ?>
                        <a href="<?= Url::to(['/auth/logout']) ?>">Выйти</a>
                    <?php else: ?>
                        <a href="<?= Url::to(['/auth/login']) ?>">Вход</a>
                        <a href="<?= Url::to(['/auth/signup']) ?>">Регистрация</a>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    </header>

    <main>
        <?= $content ?>
    </main>

    <footer class="footer">
        <div class="container">
            <p>© <?= date('Y') ?> Туры выходного дня</p>
            <p class="mt-1">+7 (999) 123-45-67 | info@tours-weekend.ru</p>
        </div>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>