<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="container" style="max-width: 600px;">
    <h1 style="margin-bottom: 2rem;">Оформление заявки</h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert success" style="margin-bottom: 1.5rem;">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <form method="post" style="background: white; padding: 2rem; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);">
        <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
        <input type="hidden" name="Booking[user_id]" value="<?= Yii::$app->user->id ?>">

        <div class="form-group" style="margin-bottom: 1.5rem;">
            <label>Тур</label>
            <?php if (!empty($tours)): ?>
                <select name="Booking[tour_id]" required style="width: 100%; padding: 0.75rem; border: 1px solid #ddd; border-radius: 4px;">
                    <option value="">— Выберите тур —</option>
                    <?php foreach ($tours as $id => $title): ?>
                        <option value="<?= $id ?>" <?= ($model->tour_id == $id) ? 'selected' : '' ?>>
                            <?= Html::encode($title) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            <?php else: ?>
                <p style="color: #999;">Нет доступных туров</p>
            <?php endif; ?>
        </div>

        <div class="form-group" style="margin-bottom: 1.5rem;">
            <label>Дата поездки</label>
            <input type="date" name="Booking[date]" value="<?= Html::encode($model->date ?? '') ?>" required style="width: 100%; padding: 0.75rem; border: 1px solid #ddd; border-radius: 4px;">
        </div>

        <div class="form-group" style="margin-bottom: 1.5rem;">
            <label>Количество участников</label>
            <input type="number" name="Booking[participants]" min="1" max="50" value="<?= Html::encode($model->participants ?? 1) ?>" required style="width: 100%; padding: 0.75rem; border: 1px solid #ddd; border-radius: 4px;">
        </div>

        <div class="form-group" style="margin-bottom: 1.5rem;">
            <label>Способ оплаты</label>
            <div style="display: flex; flex-direction: column; gap: 0.5rem; margin-top: 0.5rem;">
                <label style="display: flex; align-items: center; gap: 0.5rem;">
                    <input type="radio" name="Booking[payment_method]" value="cash" required> Наличные
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem;">
                    <input type="radio" name="Booking[payment_method]" value="card"> Карта
                </label>
                <label style="display: flex; align-items: center; gap: 0.5rem;">
                    <input type="radio" name="Booking[payment_method]" value="online"> Онлайн
                </label>
            </div>
        </div>

        <div class="form-group" style="margin-bottom: 1.5rem;">
            <label>Дополнительные пожелания</label>
            <textarea name="Booking[wishes]" maxlength="500" style="width: 100%; padding: 0.75rem; border: 1px solid #ddd; border-radius: 4px; height: 100px;"><?= Html::encode($model->wishes ?? '') ?></textarea>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 2rem;">
            <button type="submit" class="btn" style="flex: 1;">Подтвердить заявку</button>
            <a href="<?= Url::to(['/tour/index']) ?>" class="btn" style="background: #ecf0f1; color: #333;">Отмена</a>
        </div>
    </form>
</div>