<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\LinkPager;
?>

<div class="container" style="padding: 30px 0;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1>Управление турами</h1>
        <a href="<?= Url::to(['/admin/create-tour']) ?>" class="btn">+ Добавить тур</a>
    </div>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div style="background: #d4edda; color: #155724; padding: 12px; border-radius: 4px; margin-bottom: 20px;">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <div style="background: white; border: 1px solid #ddd; border-radius: 8px; overflow: hidden;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
            <tr style="background: #f8f9fa;">
                <th style="padding: 12px; text-align: left; border-bottom: 1px solid #ddd;">ID</th>
                <th style="padding: 12px; text-align: left; border-bottom: 1px solid #ddd;">Название</th>
                <th style="padding: 12px; text-align: left; border-bottom: 1px solid #ddd;">Цена</th>
                <th style="padding: 12px; text-align: left; border-bottom: 1px solid #ddd;">Действия</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($dataProvider->getModels() as $tour): ?>
                <tr>
                    <td style="padding: 12px; border-bottom: 1px solid #ddd;"><?= $tour->id ?></td>
                    <td style="padding: 12px; border-bottom: 1px solid #ddd;"><?= Html::encode($tour->title) ?></td>
                    <td style="padding: 12px; border-bottom: 1px solid #ddd;"><?= number_format($tour->price, 0, '', ' ') ?> ₽</td>
                    <td style="padding: 12px; border-bottom: 1px solid #ddd;">
                        <a href="<?= Url::to(['/admin/update-tour', 'id' => $tour->id]) ?>" class="btn" style="padding: 5px 10px; font-size: 13px;">Редактировать</a>
                        <a href="<?= Url::to(['/admin/delete-tour', 'id' => $tour->id]) ?>" class="btn" style="padding: 5px 10px; font-size: 13px; background: #dc3545;" onclick="return confirm('Удалить тур?')">Удалить</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div style="margin-top: 20px;">
        <?= LinkPager::widget([
            'pagination' => $dataProvider->pagination,
        ]) ?>
    </div>
</div>