<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\data\ActiveDataProvider;
use app\models\Tour;
use app\models\Review;

class TourController extends Controller
{
    public function actionIndex()
    {
        $query = Tour::find();

        $minPrice = Yii::$app->request->get('min_price');
        $maxPrice = Yii::$app->request->get('max_price');

        if ($minPrice !== null && $minPrice !== '') {
            $query->andWhere(['>=', 'price', $minPrice]);
        }

        if ($maxPrice !== null && $maxPrice !== '') {
            $query->andWhere(['<=', 'price', $maxPrice]);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 6,
            ],
            'sort' => [
                'defaultOrder' => ['id' => SORT_DESC],
            ],
        ]);

        // Для главной страницы - ограничим количество
        $popularTours = Tour::find()->orderBy(['id' => SORT_DESC])->limit(3)->all();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'tours' => $dataProvider->getModels(),
            'pages' => $dataProvider->getPagination(),
            'minPrice' => $minPrice,
            'maxPrice' => $maxPrice,
            'popularTours' => $popularTours,
        ]);
    }

    public function actionView($id)
    {
        $tour = Tour::findOne($id);

        if (!$tour) {
            throw new \yii\web\NotFoundHttpException('Тур не найден.');
        }

        $reviews = Review::find()
            ->where(['tour_id' => $id])
            ->with('user')
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('view', [
            'tour' => $tour,
            'reviews' => $reviews,
        ]);
    }
}