<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Review;
use app\models\Booking;

class ReviewController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionCreate($tour_id = null)
    {
        $model = new Review();
        $model->user_id = Yii::$app->user->id;

        if ($tour_id) {
            $model->tour_id = $tour_id;
        }

        $userBookingTours = Booking::find()
            ->select(['tour.id', 'tour.title'])
            ->innerJoin('tour', 'booking.tour_id = tour.id')
            ->where([
                'booking.user_id' => Yii::$app->user->id,
                'booking.status' => 'accepted'
            ])
            ->andWhere(['not exists',
                (new \yii\db\Query())
                    ->from('review r')
                    ->where('r.user_id = booking.user_id AND r.tour_id = booking.tour_id')
            ])
            ->asArray()
            ->all();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('reviewSuccess', 'Отзыв успешно добавлен.');
            return $this->redirect(['/site/index']);
        }

        return $this->render('create', [
            'model' => $model,
            'userBookingTours' => $userBookingTours,
        ]);
    }
}