<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\User;
use app\models\LoginForm;

class AuthController extends Controller
{
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();

        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';

        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionSignup()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new User();
        $model->scenario = User::SCENARIO_REGISTER;

        if (Yii::$app->request->isPost) {
            $post = Yii::$app->request->post();

            if ($model->load($post)) {
                // Для отладки - посмотрим ошибки
                if (!$model->validate()) {
                    Yii::error('Validation errors: ' . print_r($model->errors, true));
                }

                if ($model->save()) {
                    Yii::$app->session->setFlash('success', 'Регистрация успешно завершена! Теперь вы можете войти.');
                    return $this->redirect(['login']);
                } else {
                    Yii::$app->session->setFlash('error', 'Ошибка регистрации. Проверьте введенные данные.');
                }
            }
        }

        return $this->render('signup', [
            'model' => $model
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
}